package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import org.json.JSONException;
import org.json.JSONObject;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.xml.Xmler;

import java.util.Map;
import java.util.Set;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 19.09.13
 * Time: 12:49
 */
public class WebForm extends XmlStructData {

    public final String schemeUrl;
    public final Map<String, String> parameters;
    public final String sourceUrl;

    public WebForm(final String schemeUrl, final Map<String, String> parameters, final String sourceUrl) {
        this.schemeUrl = schemeUrl;
        this.parameters = parameters;
        this.sourceUrl = sourceUrl;
    }

    private static final Set<String> TAGS = Cf.set("web-form");

    @Override
    public Set<String> getEntityTags() {
        return TAGS;
    }

    @Override
    public Xmler.Tag toXml() {
        return null;
    }

    public JSONObject asJson() {
        JSONObject result = new JSONObject();
        try {
            result.put("url", sourceUrl).put("scheme-url", schemeUrl);
            result.put("parameters", parameters);
            return result;
        } catch (JSONException e) {
            throw new RuntimeException(e); // Something really strange
        }
    }

}
