package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data.transformers.impl;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances.HCard;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data.JsonStructData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data.StructuredDataTransformers;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data.transformers.JsonStructDataTransformer;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data.wrapper.BizReviewWrapper;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 13.11.13
 * Time: 6:41
 */
public class BizReviewFromMicroformatTransformer extends JsonStructDataTransformer {
    @Override
    public JsonStructData transformStruct(final Object o, final String sourceUrl) {
        MicroformatData md = (MicroformatData) o;
        return new BizReviewWrapper(StructuredDataTransformers.fromBizHReview(md, sourceUrl));
    }

    @Override
    public boolean checkType(final Object o) {
        if (!(o instanceof MicroformatData)) {
            return false;
        }
        MicroformatData md = (MicroformatData) o;
        List<MFAnyData> items = md.getDataAsList("item");
        if (!items.isEmpty()) {
            if (items.get(0) instanceof MicroformatData && items.get(0).getSpec() == HCard.getInstance()) {
                return true;
            }
        }
        return false;
    }
}
