package ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 1/17/12
 * Time: 12:40 AM
 */
public class Key {

    public final String id;
    public final boolean plural;
    public final Map<String,Value> values;

    public Key(final String id, final boolean plural) {
        this.id = id;
        this.plural = plural;
        this.values = new HashMap<String, Value>();
    }

    public String getId() {
        return id;
    }

    public boolean isPlural() {
        return plural;
    }

    public void addValue(final Value value) {
        values.put(value.getLang(),value);
    }

    public Value getValue(final String lang) {
        return values.get(lang);
    }

    public String toString() {
        String result = "{key: " + id + "\n";
        for (Value v : values.values()) {
            result += v;
        }
        result += "}\n";
        return result;
    }

}
