package ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12/10/11
 * Time: 9:12 AM
 */
public class KeySet {

    public final String id;
    public final Map<String,Key> keys;

    public KeySet(final String id) {
        this.id = id;
        keys = new HashMap<String,Key>();
    }

    public String getId() {
        return id;
    }

    public void addKey(final Key key) {
        keys.put(key.getId(),key);
    }

    public Key getKey(final String id) {
        return keys.get(id);
    }

    public String toString() {
        String result = "{key-set: " + id + "\n";
        for (Key k : keys.values()) {
            result += k;
        }
        result += "}\n";
        return result;
    }
}
