package ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker;

import static ru.yandex.common.util.StringUtils.isEmpty;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 1/17/12
 * Time: 1:03 AM
 */
public class LanguageContext {

    private final KeySet keySet;
    private final String lang;
    private final static String[] FALLBACK_LANGS = {"en", "ru"};

    public LanguageContext(final KeySet keySet, final String lang) {
        this.keySet = keySet;
        this.lang = lang;
    }

    public Value getValue(final String id) {
        final Key key = keySet.getKey(id);
        if (key == null) {
            return null;
        }
        Value value = key.getValue(lang);
        if (!isEmpty(value.getString())) {
            return value;
        }
        for (String fbLang : FALLBACK_LANGS) {
            value = key.getValue(fbLang);
            if (!isEmpty(value.getString())) {
                return value;
            }
        }
        throw new IllegalArgumentException("No such tanker key " + id);
    }
}
