package ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12/10/11
 * Time: 9:09 AM
 */
public class TankerProject {

    private final String id;
    private final Map<String, KeySet> keySets;


    public TankerProject(final String id) {
        this.id = id;
        keySets = new HashMap<String, KeySet>();
    }

    public String getId() {
        return id;
    }

    public void addKeySet(final KeySet keySet) {
        keySets.put(keySet.getId(), keySet);
    }

    public KeySet getKeySet(final String id) {
        return keySets.get(id);
    }

    public String toString() {
        String result = "{project: " + id + "\n";
        for (KeySet ks : keySets.values()) {
            result += ks;
        }
        result += "}\n";
        return result;
    }

}
