package ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 1/17/12
 * Time: 5:49 PM
 */
public class XMLProjectLoader {

    public static List<TankerProject> load(final String content) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        final TankerXMLHandler handler = new TankerXMLHandler();
        parser.parse(new ByteArrayInputStream(content.getBytes()), handler);
        return handler.getResults();
    }

    public static TankerProject loadById(final String content, final String id) throws IOException, SAXException, ParserConfigurationException {
        List<TankerProject> projects = load(content);
        for (final TankerProject project : projects) {
            if (project.getId().equals(id))
                return project;
        }
        throw new IllegalArgumentException("No such project with id "+id);
    }

    static class TankerXMLHandler extends DefaultHandler {

        private static final int START = 0;
        private static final int PROJECT_ROOT = 1;
        private static final int KEY_SET = 2;
        private static final int KEY_SINGULAR = 3;
        private static final int KEY_PLURAL = 4;
        private static final int VALUE_SINGULAR = 5;
        private static final int VALUE_PLURAL = 6;
        private static final int ONE = 7;
        private static final int SOME = 8;
        private static final int MANY = 9;
        private static final int NONE = 10;

        private static final String[] QUANT_NAME = {"one", "some", "many", "none"};

        private List<TankerProject> results = new ArrayList<TankerProject>();
        private int mode = START;
        private TankerProject currrentProject = null;
        private KeySet currentKeySet = null;
        private Key currrentKey = null;
        private Value currrentValue = null;
        private StringBuilder valueBuilder = new StringBuilder();

        public TankerXMLHandler() {
        }

        public List<TankerProject> getResults() {
            return results;
        }

        @Override
        public void startElement(final String uri, final String localname, final String qName, final Attributes attributes) throws SAXException {
            if ("project".equalsIgnoreCase(qName)) {
                if (mode != START) {
                    throw new SAXException("Wrong project tag placement");
                }
                final String id = attributes.getValue("id");
                currrentProject = new TankerProject(id);
                mode = PROJECT_ROOT;
            } else if ("keyset".equalsIgnoreCase(qName)) {
                if (mode != PROJECT_ROOT) {
                    throw new SAXException("Wrong keyset tag placement");
                }
                final String id = attributes.getValue("id");
                currentKeySet = new KeySet(id);
                mode = KEY_SET;
            } else if ("key".equalsIgnoreCase(qName)) {
                if (mode != KEY_SET) {
                    throw new SAXException("Wrong key tag placement");
                }
                final String id = attributes.getValue("id");
                final String pluralRaw = attributes.getValue("is_plural");
                final boolean isPlural = pluralRaw.equalsIgnoreCase("true");
                currrentKey = new Key(id, isPlural);
                if (isPlural) {
                    mode = KEY_PLURAL;
                } else {
                    mode = KEY_SINGULAR;
                }
            } else if ("value".equalsIgnoreCase(qName)) {
                if (mode != KEY_SINGULAR && mode != KEY_PLURAL) {
                    throw new SAXException("Wrong value tag placement");
                }
                final String lang = attributes.getValue("language");
                if (mode == KEY_SINGULAR) {
                    currrentValue = new SingularValue(lang);
                    valueBuilder.setLength(0);
                    mode = VALUE_SINGULAR;
                } else {
                    currrentValue = new PluralValue(lang);
                    mode = VALUE_PLURAL;
                }
            } else {
                for (int i = 0; i < QUANT_NAME.length; i++) {
                    if (QUANT_NAME[i].equalsIgnoreCase(qName)) {
                        if (mode != VALUE_PLURAL) {
                            throw new SAXException("Wrong " + qName + " tag placement");
                        }
                        mode = ONE + i;
                        valueBuilder.setLength(0);
                        break;
                    }
                }
            }
        }

        @Override
        public void endElement(final String uri, final String localname, final String qName) throws SAXException {
            if ("project".equalsIgnoreCase(qName)) {
                if (mode != PROJECT_ROOT) {
                    throw new SAXException("Wrong project tag closing");
                }
                results.add(currrentProject);
                currrentProject = null;
                mode = START;
            } else if ("keyset".equalsIgnoreCase(qName)) {
                if (mode != KEY_SET) {
                    throw new SAXException("Wrong keyset tag closing");
                }
                currrentProject.addKeySet(currentKeySet);
                currentKeySet = null;
                mode = PROJECT_ROOT;
            } else if ("key".equalsIgnoreCase(qName)) {
                if (mode != KEY_PLURAL && mode != KEY_SINGULAR) {
                    throw new SAXException("Wrong key tag closing");
                }
                currentKeySet.addKey(currrentKey);
                currrentKey = null;
                mode = KEY_SET;
            } else if ("value".equalsIgnoreCase(qName)) {
                if (mode != VALUE_SINGULAR && mode != VALUE_PLURAL) {
                    throw new SAXException("Wrong value tag closing");
                }
                if (mode == VALUE_SINGULAR) {
                    ((SingularValue) currrentValue).setValueText(valueBuilder.toString());
                    valueBuilder.setLength(0);
                }
                currrentKey.addValue(currrentValue);
                currrentValue = null;
                if (mode == VALUE_SINGULAR) {
                    mode = KEY_SINGULAR;
                } else {
                    mode = KEY_PLURAL;
                }
            } else {
                for (int i = 0; i < QUANT_NAME.length; i++) {
                    if (QUANT_NAME[i].equalsIgnoreCase(qName)) {
                        if (mode != ONE + i) {
                            throw new SAXException("Wrong " + qName + " tag closing");
                        }
                        if (mode == VALUE_SINGULAR) {
                            ((SingularValue) currrentValue).setValueText(valueBuilder.toString());
                        } else if (mode == ONE) {
                            ((PluralValue) currrentValue).setOneText(valueBuilder.toString());
                        } else if (mode == SOME) {
                            ((PluralValue) currrentValue).setSomeText(valueBuilder.toString());
                        } else if (mode == MANY) {
                            ((PluralValue) currrentValue).setManyText(valueBuilder.toString());
                        } else if (mode == NONE) {
                            ((PluralValue) currrentValue).setNoneText(valueBuilder.toString());
                        }
                        mode = VALUE_PLURAL;
                        break;
                    }
                }
            }
        }

        @Override
        public void characters(final char[] chars, final int i, final int i1) throws SAXException {
            valueBuilder.append(chars, i, i1);
        }

    }

}
