package ru.yandex.webmaster3.core.semantic.semantic_document_parser.util.collections;

import java.util.LinkedHashMap;
import java.util.TreeMap;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/18/11
 * Time: 7:06 PM
 * To change this template use File | Settings | File Templates.
 */
public class LFUQueue<T> implements MemoQueue<T> {

    public final int MAX_SIZE;
    private long hitCount = 0;
    private final LinkedHashMap<T, Integer> map;

    public LFUQueue(final int MAX_SIZE) {
        map = new LinkedHashMap<T, Integer>(MAX_SIZE);
        this.MAX_SIZE = MAX_SIZE;
    }

    private static long calcValue(final int hash, final int num) {
        return (((long) num) << 32) + hash;
    }

    private final TreeMap<Long, T> priorityQueue = new TreeMap<Long, T>();

    @Override
    public boolean add(final T element) {
        if (map.size() > MAX_SIZE) {
            final Long min = priorityQueue.firstKey();
            if (min != null) {
                map.remove(priorityQueue.get(min));
                priorityQueue.remove(priorityQueue.firstKey());
            }
        }
        if (map.containsKey(element)) {
            hitCount++;
            return false;
        }
        map.put(element, 1);
        priorityQueue.put(calcValue(element.hashCode(), 1), element);
        return true;
    }

    @Override
    public long getHitRatio() {
        return hitCount;
    }

}
