package ru.yandex.webmaster3.core.semantic.semantic_document_parser.util.collections;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/18/11
 * Time: 7:06 PM
 * To change this template use File | Settings | File Templates.
 */
public class LRAQueue<T> implements MemoQueue<T> {

    private long hitCount = 0;
    private final LinkedHashMap<T, Integer> map;

    public LRAQueue(final int MAX_SIZE) {
        map = new LinkedHashMap<T, Integer>(MAX_SIZE) {
            @Override
            protected boolean removeEldestEntry(final Map.Entry<T, Integer> tIntegerEntry) {
                return this.size() > MAX_SIZE;
            }
        };
    }

    @Override
    public boolean add(final T element) {
        if (map.containsKey(element)) {
            hitCount++;
            return false;
        }
        map.put(element, 1);
        return true;
    }

    @Override
    public long getHitRatio() {
        return hitCount;  //To change body of implemented methods use File | Settings | File Templates.
    }
}
