package ru.yandex.webmaster3.core.semantic.semantic_document_parser.validators;

import ru.yandex.common.util.xml.Xmler;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/14/11
 * Time: 12:23 AM
 */
public class  AggregateCardsValidator implements CardsValidator {

    private List<CardsValidator> cardsValidators = Collections.emptyList();

    public void setCardsValidators(final List<CardsValidator> cardsValidators) {
        this.cardsValidators = cardsValidators;
    }

    @Override
    public List<Xmler.Tag> process(final String content, final String url, final MessageStorage messageStorage, final String lang) {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        for (final CardsValidator validator : cardsValidators)
            tags.addAll(validator.process(content,url,messageStorage,lang));
        return tags;
    }
}
