package ru.yandex.webmaster3.core.semantic.semantic_document_parser.validators;

import org.apache.xerces.jaxp.datatype.DatatypeFactoryImpl;
import ru.yandex.common.util.Su;

import javax.xml.datatype.DatatypeFactory;
import java.util.regex.Pattern;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 27.09.12
 * Time: 19:23
 */
public class ISO8601Validator {
    private static final DatatypeFactoryImpl DATATYPE_FACTORY = new DatatypeFactoryImpl();

    public static boolean validate(final String datetime) {
        if (datetime.contains("/")) {
            String[] parts = Su.split(datetime, '/', 2);
            int durationCnt = 0;
            int datetimeCnt = 0;
            for (final String s : parts) {
                if (isDuration(s)) {
                    durationCnt++;
                } else if (isDatetime(s)) {
                    datetimeCnt++;
                } else {
                    return false;
                }
            }
            return durationCnt <= 1;
        }
        return isDatetime(datetime) || isDuration(datetime);
    }

    private final static Pattern DATETIME = Pattern.compile(
            "^([\\+-]?\\d{4}(?!\\d{2}\\b))((-?)((0[1-9]|1[0-2])(\\3([12]\\d|0[1-9]|3[01]))?|W([0-4]\\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\\d|[12]\\d{2}|3([0-5]\\d|6[1-6])))([T\\s]((([01]\\d|2[0-3])((:?)[0-5]\\d)?|24\\:?00)([\\.,]\\d+(?!:))?)?(\\17[0-5]\\d([\\.,]\\d+)?)?([zZ]|([\\+-])([01]\\d|2[0-3]):?([0-5]\\d)?)?)?)?$");

    private static boolean isDatetime(final String s) {
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            datatypeFactory.newXMLGregorianCalendar(s.trim()).toGregorianCalendar();
        } catch (Exception e) {
            return DATETIME.matcher(s).matches();
        }
        return true;
    }

    private static boolean isDuration(final String s) {
        try {
            DATATYPE_FACTORY.newDuration(s);
        } catch (Exception e) {
            return false;
        }
        return true;
    }

}
