package ru.yandex.webmaster3.core.semantic.semantic_document_parser.validators;

import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.xml.Xmler;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.MicroformatsUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.ConfigurableMFExceptionSerializer;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances.*;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/13/11
 * Time: 11:53 PM
 */
public class MicroformatCardsValidator implements CardsValidator {

    @Override
    public List<Xmler.Tag> process(final String content, final String url, final MessageStorage messageStorage, final String lang) {
        final ConfigurableMFExceptionSerializer mfExceptionSerializer = new ConfigurableMFExceptionSerializer(messageStorage,lang);
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        final Pair<List<MicroformatData>, List<MFException>> results = MicroformatsUtils.extractMF(content, url,
                MicroformatsManager.managerForMFsAndIncluded(HCard.getInstance(), HReview.getInstance(),
                        HResume.getInstance(), HRecipe.getInstance()), true);
        for (final MicroformatData data : results.first) {
            tags.add(MicroformatsUtils.toXmlTag(data, null, false));
        }
        for (final MFException ex : results.second) {
            tags.addAll(mfExceptionSerializer.toXML(ex));
        }
        return tags;
    }
}
