package ru.yandex.webmaster3.core.sitemap;

import java.util.List;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.HttpCodeInfo;

/**
 * @author aherman
 */
public class HostSitemapInfo {
    private final DateTime lastAccessDate;
    private final HttpCodeInfo httpCodeInfo;
    private final String redirectTarget;
    private final List<SitemapError> errors;
    private final List<SitemapError> warnings;

    private final Long shownErrorsCount;
    private final Long shownWarningsCount;
    private final Long urlCount;
    private final String sitemapFileName;
    private final SitemapType sitemapType;

    public HostSitemapInfo(String sitemapFileName, DateTime lastAccessDate, HttpCodeInfo httpCodeInfo, String redirectTarget,
            Long urlCount, SitemapType sitemapType, List<SitemapError> errors, List<SitemapError> warnings)
    {
        this.lastAccessDate = lastAccessDate;
        this.httpCodeInfo = httpCodeInfo;
        this.redirectTarget = HostSitemap.getRedirTargetSafe(redirectTarget, httpCodeInfo);
        this.urlCount = urlCount;
        this.errors = errors;
        this.warnings = warnings;
        this.shownErrorsCount = (long)errors.size();
        this.shownWarningsCount = (long)warnings.size();
        this.sitemapFileName = sitemapFileName;
        this.sitemapType = sitemapType;
    }

    public DateTime getLastAccessDate() {
        return lastAccessDate;
    }

    public HttpCodeInfo getHttpCodeInfo() {
        return httpCodeInfo;
    }

    public String getRedirectTarget() {
        return redirectTarget;
    }

    public List<SitemapError> getErrors() {
        return errors;
    }

    public List<SitemapError> getWarnings() {
        return warnings;
    }

    public Long getShownErrorsCount() {
        return shownErrorsCount;
    }

    public Long getShownWarningsCount() {
        return shownWarningsCount;
    }

    public Long getUrlCount() {
        return urlCount;
    }

    public String getSitemapFileName() {
        return sitemapFileName;
    }

    public SitemapType getSitemapType() {
        return sitemapType;
    }

    public static class SitemapError {
        private final long lineNumber;
        private final SitemapErrorCode code;
        private final String message;

        public SitemapError(long lineNumber, SitemapErrorCode code, String message) {
            this.lineNumber = lineNumber;
            this.code = code;
            this.message = message;
        }

        public long getLineNumber() {
            return lineNumber;
        }

        public SitemapErrorCode getCode() {
            return code;
        }

        public String getMessage() {
            return message;
        }
    }
}
