package ru.yandex.webmaster3.core.sitemap;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author azakharov
 * @author aherman
 * См.также https://a.yandex-team.ru/arc/trunk/arcadia/robot/library/sitemap/common/error_codes.h
 */
public enum SitemapErrorCode implements IntEnum {
    WRN_UNKNOWN_TAG(1),
    WRN_TAG_CANNOT_BE_EMPTY(2),
    WRN_TAG_CANNOT_BE_COMPLEX(3),
    WRN_TAG_DATA_TOO_LONG(4),
    WRN_TAG_EMPTY_DATA(5),
    WRN_PRIORITY_INVALID(6),
    WRN_LASTMOD_INVALID(7),
    WRN_TOO_MANY_WARNINGS(8),
    WRN_CHANGEFREQ_INVALID(9),
    WRN_SITEMAP_URL_REDIRECTED(1000),      // особый код для предупреждения о редиректе

    ERR_URL_TOO_LONG(100),
    ERR_URL_INVALID(101),

    ERR_UNKNOWN_TAG(102),
    ERR_TAG_CANNOT_BE_EMPTY(103),
    ERR_TAG_APPEARS_TWICE(104),
    ERR_TAG_CANNOT_BE_COMPLEX(105),
    ERR_TAG_DATA_TOO_LONG(106),
    ERR_TAG_EMPTY_DATA(107),
    ERR_INCOMPLETE_URL_DATA(108),

    ERR_HOST_NOT_CONFIRM(109),
    ERR_PREFIX_DONT_MATCH(110),
    ERR_UNEXPECTED_ENTITY(111),

    ERR_DUPLICATE_ALTERNATE_HREF(112), // duplicated alternate lang hrefs
    ERR_MISSING_ATTRIBUTE(113),
    ERR_DUPLICATE_ATTRIBUTE(114),
    ERR_INVALID_ATTRIBUTE_VALUE(115),
    ERR_UNKNOWN_ATTRIBUTE(116),
    ERR_MISSING_ELEMENT(117),
    ERR_INVALID_ELEMENT_VALUE(118),

    ERR_INVALID_TEXT_FORMAT(200),
    ERR_INVALID_XML(201),
    ERR_INVALID_MAIN_TAG(202),
    ERR_TOO_MANY_URLS(203),
    ERR_ILLEGAL_BOM(204),
    ERR_INVALID_MIME_TYPE(250),

    WRN_MEDIA_ALLOW_EMBED_INVALID(300),
    WRN_MEDIA_DURATION_INVALID(301),
    WRN_MEDIA_EXPIRATION_INVALID(302),
    WRN_MEDIA_VIEWS_INVALID(303),
    WRN_MEDIA_UPLOAD_DATE_INVALID(304),
    WRN_MEDIA_ADULT_FLAG_INVALID(305);

    private final int code;

    SitemapErrorCode(int code) {
        this.code = code;
    }

    @Override
    public int value() {
        return code;
    }

    public boolean isError() {
        return code >= 100 && code != 1000;
    }

    public static final IntEnumResolver<SitemapErrorCode> R = IntEnumResolver.r(SitemapErrorCode.class);
}
