package ru.yandex.webmaster3.core.sitemap;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 19/10/2021.
 */
@Value
public class SitemapErrorInfo {
    public static final TypeReference<List<SitemapErrorInfo>> LIST_REFERENCE = new TypeReference<>() {
    };

    long line;
    SitemapErrorCode code;
    String message;

    @JsonCreator
    public static SitemapErrorInfo fromJson(@JsonProperty("Line") long line, @JsonProperty("Code") int code, @JsonProperty("Text") String message) {
        return new SitemapErrorInfo(line, SitemapErrorCode.R.fromValueOrNull(code), message);
    }

    public HostSitemapInfo.SitemapError toSitemapError() {
        return new HostSitemapInfo.SitemapError(line, code, message);
    }
}
