package ru.yandex.webmaster3.core.sitemap;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum SitemapType implements IntEnum {
    SITEMAP(1),
    SITEMAPINDX(2),
    ;

    private final int value;

    SitemapType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<SitemapType> R = IntEnumResolver.r(SitemapType.class);
}
