package ru.yandex.webmaster3.core.sitemap;

import java.util.UUID;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class UserSitemap {
    private final WebmasterHostId hostId;
    private final String sitemapUrl;
    private final UUID sitemapId;
    private final DateTime addDate;
    private final boolean deleted;
    private final DateTime deleteDate;
    private final UserSitemapStatus status;

    public UserSitemap(WebmasterHostId hostId, String sitemapUrl, UUID sitemapId,
                       DateTime addDate, boolean deleted, DateTime deleteDate, UserSitemapStatus status)
    {
        this.hostId = hostId;
        this.sitemapUrl = sitemapUrl;
        this.sitemapId = sitemapId;
        this.addDate = addDate;
        this.deleted = deleted;
        this.deleteDate = deleteDate;
        this.status = status;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public String getSitemapUrl() {
        return sitemapUrl;
    }

    public UUID getSitemapId() {
        return sitemapId;
    }

    public DateTime getAddDate() {
        return addDate;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public DateTime getDeleteDate() {
        return deleteDate;
    }

    public UserSitemapStatus getStatus() {
        return status;
    }
}
