package ru.yandex.webmaster3.core.sitemap;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum UserSitemapStatus implements IntEnum {
    UNKNOWN(0),

    NEW(1),
    SENT_TO_UKROP(2),
    KNOWN_BY_UKROP(3)
    ;

    UserSitemapStatus(int value) {
        this.value = value;
    }

    private final int value;

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<UserSitemapStatus> R = IntEnumResolver.r(UserSitemapStatus.class);
}
