package ru.yandex.webmaster3.core.sitemap.raw;

import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.hash.HashCode;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public class HostRelatedSitemaps {
    private final UUID relationVersionId;
    private final WebmasterHostId hostId;
    private final DateTime createDate;
    private final List<RelatedSitemap> relatedSitemaps;
    private final HashCode contentHash;

    public HostRelatedSitemaps(UUID relationVersionId, WebmasterHostId hostId, DateTime createDate,
            List<RelatedSitemap> relatedSitemaps, HashCode contentHash)
    {
        this.relationVersionId = relationVersionId;
        this.hostId = hostId;
        this.createDate = createDate;
        this.relatedSitemaps = relatedSitemaps;
        this.contentHash = contentHash;
    }

    public UUID getRelationVersionId() {
        return relationVersionId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public DateTime getCreateDate() {
        return createDate;
    }

    public List<RelatedSitemap> getRelatedSitemaps() {
        return relatedSitemaps;
    }

    public HashCode getContentHash() {
        return contentHash;
    }

    public static class RelatedSitemap {
        private final String url;
        private SitemapSource source;
        private final DateTime addTime;

        public RelatedSitemap(String url,
                SitemapSource source,
                DateTime addTime) {
            this.url = url;
            this.source = source;
            this.addTime = addTime;
        }

        // For json
        public RelatedSitemap(@JsonProperty("url") String url,
                @JsonProperty("addTime") DateTime addTime)
        {
            this.url = url;
            this.addTime = addTime;
        }

        public String getUrl() {
            return url;
        }

        public SitemapSource getSource() {
            return source;
        }

        public void setSource(int source) {
            this.source = SitemapSource.R.fromValueOrUnknown(source);
        }

        public DateTime getAddTime() {
            return addTime;
        }
    }

    public static enum SitemapSource implements IntEnum {
        UNKNOWN(-1),

        ROBOTS_TXT(0),
        WEBMASTER(1),
        SITEMAP_INDEX(2),
        ;

        private final int value;

        SitemapSource(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return value;
        }

        public static final IntEnumResolver<SitemapSource> R = IntEnumResolver.r(SitemapSource.class);
    }
}
