package ru.yandex.webmaster3.core.sitemap.raw;

import com.google.common.hash.HashCode;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class HostRelatedSitemapsMeta {
    private final UUID relationVersionId;
    private final WebmasterHostId hostId;
    private final DateTime createDate;
    private final HashCode contentHash;

    public HostRelatedSitemapsMeta(UUID relationVersionId, WebmasterHostId hostId, DateTime createDate, HashCode contentHash) {
        this.relationVersionId = relationVersionId;
        this.hostId = hostId;
        this.createDate = createDate;
        this.contentHash = contentHash;
    }

    public UUID getRelationVersionId() {
        return relationVersionId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public DateTime getCreateDate() {
        return createDate;
    }

    public HashCode getContentHash() {
        return contentHash;
    }
}
