package ru.yandex.webmaster3.core.sitemap.raw;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.sitemap.HostSitemap;
import ru.yandex.webmaster3.core.sitemap.SitemapErrorCode;

import java.util.List;

/**
 * @author aherman
 */
@Getter
public class RawSitemapInfo {
    private final String sitemapUrl;
    private final boolean index;
    private final int httpStatusCode;
    private final DateTime lastAccessDate;
    private final int urlsCount;
    private final List<String> urls;
    private final int errorsCount;
    private final List<SitemapError> errors;
    private final String redirectTarget;
    private final DateTime modificationDate;

    public RawSitemapInfo(String sitemapUrl, boolean index, int httpStatusCode, DateTime lastAccessDate,
                          int urlsCount, List<String> urls, int errorsCount, List<SitemapError> errors,
                          String redirectTarget, DateTime modificationDate)
    {
        this.sitemapUrl = sitemapUrl;
        this.index = index;
        this.httpStatusCode = httpStatusCode;
        this.lastAccessDate = lastAccessDate;
        this.urlsCount = urlsCount;
        this.urls = urls;
        this.errorsCount = errorsCount;
        this.errors = errors;
        this.redirectTarget = HostSitemap.getRedirTargetSafe(redirectTarget, httpStatusCode);
        this.modificationDate = modificationDate;
    }

    // Сайтмеп в настоящий момент зафильтрован Лемуром и не обходится,
    // и у нас нет никакой предыдущей информации о нем
    public boolean hasLastAccess() {
        return lastAccessDate != null && !lastAccessDate.isEqual(0);
    }

    public static class SitemapError {
        private int line;
        private SitemapErrorCode sitemapErrorCode;
        private String message;

        public int getLine() {
            return line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        @JsonIgnore
        public SitemapErrorCode getSitemapErrorCode() {
            return sitemapErrorCode;
        }

        public int getErrorCode() {
            return sitemapErrorCode.value();
        }

        public void setErrorCode(int errorCode) {
            this.sitemapErrorCode = SitemapErrorCode.R.fromValueOrUnknown(errorCode);
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}
