package ru.yandex.webmaster3.core.sitestructure;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.searchbase.SearchBaseDates;
import ru.yandex.webmaster3.core.searchbase.SearchBaseSwitchUtil;

import java.util.List;
import java.util.UUID;

/**
 * @author aherman
 */
public class DoubleSourcedSiteStructure extends NewSiteStructureGeneration {
    private final NewSiteStructure curStructure;
    private final NewSiteStructure nextBaseStructure;
    private final Instant nextBaseDate;
    private final Instant curBaseDate;

    public DoubleSourcedSiteStructure(NewSiteStructure curStructure, Instant curBaseDate, NewSiteStructure nextBaseStructure, Instant nextBaseDate) {
        super(curStructure.getHostId(), curStructure.getSiteStructureGenerationId().getSiteTreeGenerationId(), curStructure.getRealDataCollectionDate());
        this.nextBaseStructure = nextBaseStructure;
        this.curStructure = curStructure;
        this.nextBaseDate = nextBaseDate;
        this.curBaseDate = curBaseDate;
    }

    public DoubleSourcedSiteStructure(WebmasterHostId hostId, UUID siteStructureGenerationUUID, DateTime realDataCollectionDate,
                                      List<NewSiteStructureNode> curAutoNodes, List<NewSiteStructureNode> curUserNodes,
                                      Instant curBaseDate, List<NewSiteStructureNode> nextBaseAutoNodes, List<NewSiteStructureNode> nextBaseUserNodes,
                                      Instant nextBaseDate) {
        super(hostId, siteStructureGenerationUUID, realDataCollectionDate);
        this.curBaseDate = curBaseDate;
        this.curStructure = new NewSiteStructure(hostId, siteStructureGenerationUUID, realDataCollectionDate, curAutoNodes, curUserNodes);
        if (nextBaseDate == null) {
            this.nextBaseDate = null;
            this.nextBaseStructure = null;
        } else {
            this.nextBaseDate = nextBaseDate;
            this.nextBaseStructure = new NewSiteStructure(hostId, siteStructureGenerationUUID, realDataCollectionDate, nextBaseAutoNodes, nextBaseUserNodes);
        }
    }

    public NewSiteStructure getCurStructure() {
        return curStructure;
    }

    public NewSiteStructure getNextBaseStructure() {
        return nextBaseStructure;
    }

    public Instant getNextBaseDate() {
        return nextBaseDate;
    }

    public NewSiteStructure toSiteStructure(SearchBaseDates searchBaseDates, Instant now) {
        return SearchBaseSwitchUtil.selectDoubleSourcedData(curStructure, nextBaseStructure, nextBaseDate, searchBaseDates, now);
    }

    public Instant getCurBaseDate() {
        return curBaseDate;
    }
}
