package ru.yandex.webmaster3.core.sitestructure;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

/**
 * @author aherman
 */
public class NewSiteStructure extends NewSiteStructureGeneration {
    public static long ROOT_NODE_ID = 47; // "//".hash()

    private final List<NewSiteStructureNode> siteNodes;
    private final List<NewSiteStructureNode> userDefinedNodes;

    public NewSiteStructure(WebmasterHostId hostId, UUID siteStructureGenerationUUID,
                            DateTime realDataCollectionDate, List<NewSiteStructureNode> siteNodes,
                            List<NewSiteStructureNode> userDefinedNodes) {
        super(hostId, siteStructureGenerationUUID, realDataCollectionDate);
        this.siteNodes = siteNodes;
        this.userDefinedNodes = userDefinedNodes;
    }

    public List<NewSiteStructureNode> getSiteNodes() {
        return siteNodes;
    }

    public List<NewSiteStructureNode> getUserDefinedNodes() {
        return userDefinedNodes;
    }

    public NewSiteStructureNode findNode(long nodeId) {
        Optional<NewSiteStructureNode> node = getSiteNodes()
                .stream()
                .filter(n -> n.getNodeId() == nodeId)
                .findFirst();
        return node.orElse(null);
    }

    public List<NewSiteStructureNode> getAllNodes() {
        ArrayList<NewSiteStructureNode> result = new ArrayList<>();
        result.addAll(siteNodes);
        result.addAll(userDefinedNodes);
        return result;
    }

    public NewSiteStructure withFixedUserNodes(List<NewSiteStructureNode> userNodes) {
        return new NewSiteStructure(getHostId(), getSiteStructureGenerationId().getSiteTreeGenerationId(),
                getRealDataCollectionDate(), siteNodes, userNodes);
    }
}
