package ru.yandex.webmaster3.core.sitestructure;

import com.datastax.driver.core.utils.UUIDs;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.sitestructure.SiteTreeGenerationId;

import java.util.UUID;

/**
 * @author aherman
 */
public class NewSiteStructureGeneration {
    private final WebmasterHostId hostId;
    private final UUID siteStructureGenerationUUID;
    private final DateTime realDataCollectionDate;

    public NewSiteStructureGeneration(WebmasterHostId hostId, UUID siteStructureGenerationUUID, DateTime realDataCollectionDate) {
        this.hostId = hostId;
        this.siteStructureGenerationUUID = siteStructureGenerationUUID;
        this.realDataCollectionDate = realDataCollectionDate;
    }

    public SiteTreeGenerationId getSiteStructureGenerationId() {
        return SiteTreeGenerationId.create(hostId, siteStructureGenerationUUID);
    }

    public DateTime getRealDataCollectionDate() {
        return realDataCollectionDate;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public DateTime getCreateDate() {
        return new DateTime(UUIDs.unixTimestamp(siteStructureGenerationUUID));
    }
}
