package ru.yandex.webmaster3.core.sitestructure;

import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.With;

import ru.yandex.webmaster3.core.turbo.model.TurboSource;

/**
 * @author aherman
 */
@Value
@Builder
@AllArgsConstructor
@With
public class NewSiteStructureNode implements TreeNode {
    long nodeId;
    Long parentNodeId;
    String name;
    long docCount;
    long searchDocCount;
    long turboDocCount;
    Map<Integer, Long> httpCodes;
    long newSearchUrls;
    long goneSearchUrls;
    Map<SearchUrlStatusEnum, Long> excludedStatuses;
    Map<TurboSource, Long> searchTurboDocs;

    public boolean isRoot() {
        return parentNodeId == null;
    }

    @Override
    public long getNodeId() {
        return nodeId;
    }

    @Override
    public Long getParentId() {
        return parentNodeId;
    }

    @Override
    public String getRelativeName() {
        return name;
    }

    @Override
    public boolean isRootNode() {
        return parentNodeId == null || parentNodeId == 0L;
    }

    public NewSiteStructureNode withFixedNodeId(long newNodeId) {
        return new NewSiteStructureNode(newNodeId, parentNodeId, name, docCount, searchDocCount, turboDocCount, httpCodes, newSearchUrls,
                goneSearchUrls, excludedStatuses, searchTurboDocs);
    }

    @Override
    public String toString() {
        return "Node{" + nodeId + ", " + parentNodeId + ", " + name + ")}";
    }
}
