package ru.yandex.webmaster3.core.sitestructure;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * WTF: almost exact copy of robot/jupiter/protos/acceptance.proto
 *
 * @author avhaliullin
 */
public enum RawSearchUrlStatusEnum implements IntEnum {
    NOTHING_FOUND(-1),
    OTHER(0),
    NOT_MAIN_MIRROR(1),
    ROBOTS_HOST_ERROR(2),
    INDEXED(3),
    REDIRECT(4),
    SEMIDUP(5),
    NOT_CANONICAL(6),
    SR(7),
    HTTP_ERROR(8),
    PARSER_ERROR(9),
    SPAM(10),
    HOST_ERROR(11),
    ROBOTS_URL_ERROR(12),
    CLEAN_PARAMS(13),
    NO_INDEX(14),
    BAD_MIME_TYPE(15),
    FRESH(16),
    ;

    private final int value;

    RawSearchUrlStatusEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<RawSearchUrlStatusEnum> R = IntEnumResolver.r(RawSearchUrlStatusEnum.class);
}
