package ru.yandex.webmaster3.core.sitestructure;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 * TODO !!! ВНИМАНИЕ: При любых изменениях необходимо синхронизировать логику с /wmconsole/version3/wmcutil/wmc_search_url_status
 */
public enum SearchUrlStatusEnum implements IntEnum {
    @Description("Страница проиндексирована и находится в поиске")
    INDEXED_SEARCHABLE(1),
    @Description("Страница относится к неглавному зеркалу сайта (MainMirrorHost), поэтому была исключена из поиска.")
    NOT_MAIN_MIRROR(2),
    @Description("Индексирование сайта запрещено в файле robots.txt. Робот автоматически начнет посещать страницу, когда сайт станет доступен для индексирования.")
    ROBOTS_HOST_ERROR(3),
    @Description("Страница проиндексирована и присутствует в поиске по адресу BeautyURL. Если содержимое страниц идентично, используйте 301 редирект, чтобы явно указать адрес для индексирования.")
    INDEXED_NOTSEARCHABLE(4),
    @Description("Страница проиндексирована и находится в поиске:")
    REDIRECT_SEARCHABLE(5),
    @Description("Страница осуществляет перенаправление, при котором индексируется его цель (RedirectTarget). Проверьте индексирование страницы, на которую выполняется редирект.")
    REDIRECT_NOTSEARCHABLE(6),
    @Description("Страница дублирует уже представленную в поиске страницу сайта (BeautyUrl). Укажите роботу предпочтительный адрес с помощью 301 редиректа или атрибута canonical. Если содержимое страниц различается, добавьте их на переобход, чтобы ускорить обновление данных в поисковой базе.")
    SEMIDUP(7),
    @Description("Страница проиндексирована по каноническому адресу (RelCanonicalTarget), который был указан в атрибуте rel=\"canonical\" в её исходном коде. Исправьте или удалите атрибут canonical, если он указан некорректно. Робот отследит изменения автоматически.")
    NOT_CANONICAL(8),
    @Description("Страница отсутствует в поиске в результате работы алгоритма. Если алгоритм сочтет страницу достаточно релевантной запросам пользователей, она появится в поиске автоматически")
    SR(9),
    @Description("При обращении к странице (LastAccess) возникла ошибка HTTP_ERROR. Проверьте ответ сервера. Если проблема актуальна, обратитесь к администратору своего сайта или сервера. Если страница уже доступна, отправьте её на переобход.")
    HTTP_ERROR(10),
    @Description("При обращении к странице (LastAccess) роботу не удалось получить ее содержимое. Проверьте ответ сервера или наличие запрещающих HTML-тегов. Если проблема актуальна, обратитесь к администратору своего сайта или сервера. Если страница уже доступна, отправьте её на переобход.")
    PARSER_ERROR(11),
    @Description("При обращении к сайту роботу не удалось установить соединение с сервером. Проверьте ответ сервера, убедитесь в отсутствии блокировки нашего робота на стороне провайдера. Сайт начнет индексироваться автоматически, если станет доступным для робота.")
    HOST_ERROR(12),
    @Description("Индексирование страницы запрещено в robots.txt. Робот автоматически начнет посещать страницу, когда она станет доступной для индексирования.")
    ROBOTS_URL_ERROR(13),
    @Description("У робота нет актуальных данных для страницы. Проверьте ответ сервера или наличие запрещающих HTML-тегов. Если проблема актуальна, обратитесь к администратору своего сайта или сервера. Если страница уже доступна, отправьте её на переобход.")
    OTHER(14),
    @Deprecated
    @Description("Роботу неизвестно о странице или она длительное время была недоступна. Сообщите о странице с помощью инструмента в Вебмастере, в течение 1-2 недель она проиндексируется.")
    NOTHING_FOUND(15),
    @Description("Страница была исключена из поиска в результате обработки роботом директивы Clean-param. Чтобы страница индексировалась, измените robots.txt")
    CLEAN_PARAMS(16),
    @Description("Страница исключена из-за тега noindex")
    NO_INDEX(17),
    @Description("Неподдерживаемый формат документа")
    BAD_MIME_TYPE(18),
    ;

    private final int value;

    SearchUrlStatusEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isSearchable() {
        return this == INDEXED_SEARCHABLE || this == REDIRECT_SEARCHABLE;
    }

    public static final EnumResolver<SearchUrlStatusEnum> R = EnumResolver.er(SearchUrlStatusEnum.class);
    public static final IntEnumResolver<SearchUrlStatusEnum> IR = IntEnumResolver.r(SearchUrlStatusEnum.class);
}
