package ru.yandex.webmaster3.core.sitestructure;

import java.util.UUID;

import com.datastax.driver.core.utils.UUIDs;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author aherman
 */
public interface SiteTreeGenerationId {
    public WebmasterHostId getHostId();

    public UUID getSiteTreeGenerationId();

    default DateTime getCreatedAt() {
        return new DateTime(UUIDs.unixTimestamp(getSiteTreeGenerationId()));
    }

    default public boolean equalsTo(SiteTreeGenerationId that) {
        return getHostId().equals(that.getHostId()) && getSiteTreeGenerationId().equals(that.getSiteTreeGenerationId());
    }

    public static SiteTreeGenerationId create(WebmasterHostId hostId, UUID siteTreeGenerationId) {
        return new SiteTreeGenerationId() {
            @Override
            public WebmasterHostId getHostId() {
                return hostId;
            }

            @Override
            public UUID getSiteTreeGenerationId() {
                return siteTreeGenerationId;
            }

            @Override
            public boolean equals(Object o) {
                return o instanceof SiteTreeGenerationId && this.equalsTo((SiteTreeGenerationId) o);
            }
        };
    }
}
