package ru.yandex.webmaster3.core.sitestructure;

import java.util.Comparator;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.webmaster3.core.turbo.model.TurboSource;

/**
 * User: azakharov
 * Date: 22.08.14
 * Time: 16:53
 */
@Value
@Builder(toBuilder = true)
@AllArgsConstructor
public class SiteTreeNode implements TreeNode {
    public static final long ROOT_NODE_ID = createNodeId("/", false);

    long id;
    Long parentId;
    String name;
    String originalName;
    Long docCount;
    Long searchDocCount;
    Long turboDocCount;
    boolean isUserNode;
    Map<TurboSource, Long> searchTurboDocs;

    public static long createNodeId(final String nodeName, final boolean isUserNode) {
        return (isUserNode) ? ("user::" + nodeName).hashCode() : nodeName.hashCode();
    }

    @JsonIgnore
    @Override
    public long getNodeId() {
        return id;
    }

    @JsonIgnore
    @Override
    public String getRelativeName() {
        return name;
    }

    @JsonIgnore
    @Override
    public boolean isRootNode() {
        return parentId == null;
    }

    public static final Comparator<SiteTreeNode> NODE_COMPARATOR =
            Comparator.comparing(SiteTreeNode::getSearchDocCount, Comparator.nullsFirst(null)).reversed().thenComparing(SiteTreeNode::getName);
}
