package ru.yandex.webmaster3.core.solomon;

import ru.yandex.webmaster3.core.solomon.metric.SolomonKey;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author tsyplyaev
 */
public class SolomonSensor {

    public static final String LABEL_INDICATOR = "indicator";
    public static final String LABEL_TIME_BUCKET = "time_bucket";
    public static final String LABEL_SECTION = "section";
    public static final String LABEL_CATEGORY = "category";
    public static final String LABEL_DATA_TYPE = "data_type";
    public static final String LABEL_TASK = "task";
    public static final String LABEL_HOST = "host";

    private final Map<String, String> labels;
    private final long ts;
    private final Number value;

    public SolomonSensor(Map<String, String> labels, long ts, Number value) {
        this.labels = labels;
        this.ts = ts;
        this.value = value;
    }

    public SolomonSensor(long ts, Number value) {
        this(new HashMap<>(), ts, value);
    }

    public static SolomonSensor create(long ts, Number value) {
        return new SolomonSensor(ts, value);
    }

    public static SolomonSensor createAligned(long alignSeconds, Number value) {
        return createAligned(SolomonKey.create(), System.currentTimeMillis(), alignSeconds, value);
    }

    public static SolomonSensor createAligned(long timestamp, long alignSeconds, Number value) {
        return createAligned(SolomonKey.create(), timestamp, alignSeconds, value);
    }

    public static SolomonSensor createAligned(SolomonKey key, long timestamp, long alignSeconds, Number value) {
        long now = (timestamp / (TimeUnit.SECONDS.toMillis(alignSeconds))) * alignSeconds;
        return new SolomonSensor(key.getLabels(), now, value);
    }

    public SolomonSensor withLabel(String name, String value) {
        Map<String, String> newLabels = new HashMap<>(labels);
        newLabels.put(name, value);
        return new SolomonSensor(Collections.unmodifiableMap(newLabels), this.ts, this.value);
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public long getTs() {
        return ts;
    }

    public Number getValue() {
        return value;
    }
}
