package ru.yandex.webmaster3.core.solomon.metric;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class SolomonMetricConfiguration {
    private Set<Set<String>> groupBy;
    private String indicator;
    private double exportCoefficient = 1.;
    private boolean enable = true;

    public SolomonMetricConfiguration() {
    }

    public SolomonMetricConfiguration(Set<Set<String>> groupBy, String indicator, double exportCoefficient, boolean enable) {
        this.groupBy = groupBy;
        this.indicator = indicator;
        this.exportCoefficient = exportCoefficient;
        this.enable = enable;
    }

    public Set<Set<String>> getGroupBy() {
        return groupBy;
    }

    /**
     * Список необходимых группировок меток. Каждая группировка задается как "label1,label2".
     * По умолчанию используется одна группировка - по всем меткам (то есть фактически без группировки).
     * Если группировки заданы явно - то группировки по всем меткам не будет - ее так же нужно прописать явно, если она нужна
     */
    public void setGroupBy(List<String> groupBy) {
        setParsedGroupBy(parseGroupBy(groupBy));
    }

    public void setParsedGroupBy(Set<Set<String>> groupBy) {
        this.groupBy = groupBy;
    }

    public boolean isEnable() {
        return enable;
    }

    /**
     * Включить/выключить сбор метрик
     */
    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getIndicator() {
        return indicator;
    }

    /**
     * Значение метки indicator
     */
    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public double getExportCoefficient() {
        return exportCoefficient;
    }

    /**
     * Коэффициент, с которым индикатор будет выгружаться в соломон
     */
    public void setExportCoefficient(double exportCoefficient) {
        this.exportCoefficient = exportCoefficient;
    }

    public SolomonMetricConfiguration copy() {
        return new SolomonMetricConfiguration(groupBy, indicator, exportCoefficient, enable);
    }

    static Set<Set<String>> parseGroupBy(List<String> groupBy) {
        Set<Set<String>> result = new HashSet<>();
        for (String group : groupBy) {
            if (StringUtils.isEmpty(group)) {
                result.add(Collections.emptySet());
            } else {
                String[] labels = group.split(",");
                Set<String> labelsSet = new HashSet<>();
                labelsSet.addAll(Arrays.asList(labels));
                result.add(labelsSet);
            }
        }
        return result;
    }
}
