package ru.yandex.webmaster3.core.sup.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

/**
 * ishalaru
 * 04.08.2020
 **/
@Value
public class BellQuery {
    List<String> receiver;
    Long ttl;
    String project;
    @JsonProperty("bell_features")
    BellNotification bellNotification;
    @JsonProperty("throttle_policies")
    Query.ThrottlePolicies policy;
    String schedule;
    boolean adjust_time_zone;

    @Value
    public static class BellNotification {
        String actor;
        String type;
        String service;
        BellMeta meta;


        public interface BellMeta {

        }
    }
    @Value
    public static class UID {
        String uid;

        @Override
        public String toString() {
            return "uid:" + uid;
        }

        public static String fromUID(Long uid) {
            //return "uid:" + uid;
            return "tag:uid=='" + uid + "' and app_id==bell";
        }
    }
}
