package ru.yandex.webmaster3.core.sup.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

/**
 * ishalaru
 * 19.03.2020
 **/
@Value
public class Query {
    List<String> receiver;
    Long ttl;
    String project;
    PushData data;
    Notification notification;
    //@JsonProperty("bell_features")
    //BellNotification bellNotification;
    @JsonProperty("android_features")
    AndroidFeatures androidFeatures;
    PushMeta meta;
    @JsonProperty("throttle_policies")
    ThrottlePolicies policy;
    String schedule;
    boolean adjust_time_zone;


    @Value
    public static class PushMeta {
        String title;

        public static PushMeta create(String title) {
            return new PushMeta(title);
        }
    }

    @Value
    public static class AndroidFeatures {
        String subText;
        String style;

        public static AndroidFeatures create(String title) {
            return new AndroidFeatures(title, "metrica");
        }
    }


    @Value
    public static class PushData {
        @JsonProperty("push_id")
        String pushId;
        @JsonProperty("server_content_id")
        String contentId;

        public static PushData create(String pushId, String contentId) {
            return new PushData(pushId, contentId);
        }
    }

    @Value
    public static class Notification {
        String title;
        String body;
        String link;
        String icon;
    }

    @Value
    public static class ThrottlePolicies {
        @JsonProperty("install_id")
        String installId;
        @JsonProperty("content_id")
        String contentId;
    }

    @Value
    public static class UID {
        String uid;

        @Override
        public String toString() {
            return "uid:" + uid;
        }

        public static String fromUID(Long uid) {
            return "uid:" + uid;
            //return "tag:uid=='" + uid + "' AND (app_id LIKE 'ru.yandex.searchplugin%' OR app_id IN ('YandexBrowser'))";
        }
    }

}
