package ru.yandex.webmaster3.core.turbo;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

import java.util.Set;
import java.util.UUID;

/**
 * Created by Oleg Bazdyrev on 19/04/2018.
 */
public class LoadTurboErrorContentTaskData extends WorkerTaskData {

    private final String feedUrl;
    private final String itemUrl;
    private final TurboFeedType feedType;

    public LoadTurboErrorContentTaskData(UUID taskId, WebmasterHostId hostId, String feedUrl, String itemUrl,
                                         TurboFeedType feedType) {
        super(taskId, hostId);
        this.feedUrl = feedUrl;
        this.itemUrl = itemUrl;
        this.feedType = feedType;
    }

    public String getFeedUrl() {
        return feedUrl;
    }

    public String getItemUrl() {
        return itemUrl;
    }

    public TurboFeedType getFeedType() {
        return feedType;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.LOAD_TURBO_ERROR_CONTENT;
    }

    @Override
    public String getShortDescription() {
        return "Loading content from feed '" + feedUrl + "' for item '" + itemUrl + "'";
    }
}
