package ru.yandex.webmaster3.core.turbo;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/**
 * Created by Oleg Bazdyrev on 20/04/2018.
 */
public interface TurboConstants {

    // tags
    String TAG_RSS = "rss";
    String TAG_YML = "yml_catalog";
    String TAG_CHANNEL = "channel";
    String TAG_SHOP = "shop";
    String TAG_ITEM = "item";
    String TAG_OFFER = "offer";
    String TAG_OFFERS = "offers";
    String TAG_TITLE = "title";
    String TAG_LINK = "link";
    String TAG_URL = "url";
    String TAG_DESCRIPTION = "description";
    String TAG_PUD_DATE = "pubDate";
    String TAG_CATEGORIES = "categories";
    String TAG_CATEGORY = "category";
    String TAG_CATEGORY_ID = "categoryId";
    String FIELD_ITEM_URL = "item_url";

    int MAX_ITEMS_FOR_PREVIEW = 10;
    DateTimeFormatter PUB_DATE_FORMAT = DateTimeFormat.forPattern("EEE, dd MMM YYYY HH:mm:ss Z");

    int MAX_MENU_ITEMS = 200; // pretty much unlimited
    int MAX_TOP_MENU_ITEMS = 4;
    int MAX_MENU_DEPTH = 5;

    // e-commerce constants
    int MAX_COMMERCE_INFO_SECTIONS = 20;
    int MAX_COMMERCE_INFO_SECTION_SIZE = 1024 * 50;
    int MAX_COMMERCE_DELIVERY_SETTINGS = 10;

    String PLACEHOLDER_CART_URL_OFFER_ID = "{offer_id}";
    String PLACEHOLDER_CART_URL_OFFER_URL = "{offer_url}";
    String PLACEHOLDER_SEARCH_URL_TEXT = "{text}";
    int MAX_FEEDBACK_BUTTONS = 4;

    int MAX_ANALYTICS_SETINGS = 10;

    String TURBO_BASE_URL = "https://yandex.ru/turbo?text=";
    String TURBO_LISTINGS_SUFFIX = "%2Fyandexturbocatalog%2F";
    String PREVIEW_URL_SUFFIX = "&from=webmaster&nomooa=1&ncrnd=";
    String PREVIEW_SHOP_URL_SUFFIX = "&ecom-theme=1&ecommerce_new_header_preview=1";
    String NO_REDIRECT_PARAM = "&noredirect=1";

    String SANDBOX_PREVIEW_PATH = "/turbo-sandbox-preview";

    int MIN_FAVICON_SIZE_FOR_LOGO = 96;
    String PHONE_SCHEME = "tel:";
    String EMAIL_SCHEME = "mailto:";
}
