package ru.yandex.webmaster3.core.turbo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

@JsonIgnoreProperties(ignoreUnknown = true)
@lombok.Value
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class TurboUrlBanServiceResponse {
    @JsonProperty("status")
    Status status;

    @JsonProperty("error_code")
    ErrorCode errorCode;

    public enum Status {
        success,
        error,
    }

    public enum ErrorCode {
        BAD_TURBO_URL,
        BAD_DOMAIN,
    }

    public boolean isSuccess() {
        return status == Status.success;
    }
}
