package ru.yandex.webmaster3.core.turbo;

import org.apache.commons.lang3.ObjectUtils;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

/**
 * Created by Oleg Bazdyrev on 02/08/2017.
 */
public class ValidateTurboFeedTaskData extends WorkerTaskData {

    private final String feedUrl;
    private final boolean renewHost; // обновить ли robots.txt
    private final TurboFeedType feedType;

    public ValidateTurboFeedTaskData(WebmasterHostId hostId, String feedUrl, boolean renewHost, TurboFeedType feedType) {
        // таски запускаются в результате пользовательских действий, поэтому логично ожидать наивысшего приоритета
        super(hostId, WorkerTaskPriority.HIGHEST);
        this.feedUrl = feedUrl;
        this.renewHost = renewHost;
        this.feedType = ObjectUtils.firstNonNull(feedType, TurboFeedType.RSS);
    }

    public String getFeedUrl() {
        return feedUrl;
    }

    public boolean isRenewHost() {
        return renewHost;
    }

    public TurboFeedType getFeedType() {
        return feedType;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.VALIDATE_TURBO_FEED;
    }

    @Override
    public String getShortDescription() {
        return "Validation of turbo-feed " + feedUrl;
    }
}
