package ru.yandex.webmaster3.core.turbo.adv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.RequiredArgsConstructor;
import lombok.Value;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;

/**
 * ishalaru
 * 09.09.2020
 **/
@Value
@RequiredArgsConstructor(onConstructor_ = @JsonCreator)
public class AutoAdvUserVerifyTaskData extends WorkerTaskData {
    @JsonProperty("hostId")
    WebmasterHostId hostId;
    @JsonProperty("email")
    String email;
    @JsonProperty("userId")
    Long userId;
    @JsonProperty("key")
    String key;

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.TURBO_AUTO_ADV_VERIFICATION_MAIL;
    }

    @Override
    public String getShortDescription() {
        return "Send email for make adv from other host";
    }
}
