package ru.yandex.webmaster3.core.turbo.adv.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

/**
 * ishalaru
 * 01.09.2020
 **/
@Value
public class AdvDomain implements IAdvRequest {
    private static final String PI_DOMAIN_QUERY = "[\"AND\",[[\"domain\",\"=\",\"%s\"],[\"login\",\"MATCH\",[\"user\",\"MATCH\",[\"login\",\"=\",\"%s\"]]]]]";
    private static final String SITE = "site";
    private String domain;
    private String login;

    public AdvDomain(String domain, String login) {
        this.domain = domain;
        this.login = login;
    }

    @Override
    public String getComponentType() {
        return SITE;
    }

    @Override
    public Object getRequestObject() {
        return new Data(SITE, new Attributes(domain, login));
    }

    @Override
    public String getCheckExistQuery() {
        return String.format(PI_DOMAIN_QUERY, domain, login);
    }


    @Value
    public class Data {
        String type;
        Attributes attributes;
    }

    @Value
    public class Attributes {
        String domain;
        @JsonProperty("login_owner")
        String login;
    }

}
