package ru.yandex.webmaster3.core.turbo.adv.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

/**
 * ishalaru
 * 01.09.2020
 **/
@Value
public class AdvPage implements IAdvRequest {
    public static final String TYPE = "context_on_site_campaign";
    private static final String USER_FIELDS_TEMPLATE = "[\"AND\",[[\"multistate\",\"=\",\"working\"],[\"all_domain\",\"=\",\"%s\"],[\"owner\",\"MATCH\",[\"login\",\"=\",\"%s\"]]]]";

    String domain;
    long domainId;
    String login;
    String caption;

    @Override
    public String getComponentType() {
        return TYPE;
    }

    @Override
    public Object getRequestObject() {
        return new Data(TYPE, new Attributes(login, domainId, caption));
    }

    @Override
    public String getCheckExistQuery() {
        return String.format(USER_FIELDS_TEMPLATE, domain, login);
    }

    @Value
    public class Data {
        String type;
        Attributes attributes;
    }

    @Value
    public class Attributes {
        String login;
        @JsonProperty("domain_id")
        long domainId;
        String caption;
    }


}
