package ru.yandex.webmaster3.core.turbo.adv.model;

import lombok.Value;

/**
 * ishalaru
 * 07.09.2020
 **/
@Value
public class AdvUser implements IAdvRequest {
    private static final String SEARCH_PATTERN = "[\"id\",\"=\",%s]";
    private static final String TYPE = "users";
    Long uid;

    @Override
    public String getComponentType() {
        return TYPE;
    }

    @Override
    public Object getRequestObject() {
        throw new UnsupportedOperationException("Create user impossible");
    }

    @Override
    public String getCheckExistQuery() {
        return String.format(SEARCH_PATTERN, uid);
    }
}
