package ru.yandex.webmaster3.core.turbo.adv.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Value;

/**
 * ishalaru
 * 08.09.2020
 **/
@Value
@Builder
public class BlockAttributes {
    @JsonProperty("page_id")
    Long pageId;
    @JsonProperty("caption")
    String caption;
    @JsonProperty("blind")
    long blind;
    @JsonProperty("site_version")
    String siteVersion;
    @JsonProperty("design_templates")
    List<Template> templates;
    @JsonProperty("strategy")
    long strategy;
    @JsonProperty("dsp_blocks")
    List<String> dspBlocks;

    @Value
    @Builder
    public static class Template {
        @JsonProperty("design_settings")
        ISettings settings;
        @JsonProperty("is_custom_format_direct")
        boolean isCustom;
        @JsonProperty("filter_tags")
        List<String> filterTags;
        @JsonProperty("caption")
        String caption;
        @JsonProperty("type")
        String type;
    }

    public interface ISettings {

    }

    @Value
    @Builder
    public static class TGASetting implements ISettings {
        @JsonProperty("name")
        String name;
        @JsonProperty("limit")
        Integer limit;
    }

    @Value
    @Builder
    public static class MediaSettings implements ISettings {

        @JsonProperty("filterSizes")
        Boolean filterSizes;
        @JsonProperty("horizontalAlign")
        Boolean horizontalAlign;
    }
}
