package ru.yandex.webmaster3.core.turbo.adv.model.response;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Value;

/**
 * ishalaru
 * 26.03.2021
 **/
public class ExtendedAttributeInfoResponse extends Response {
    @Getter
    private final ExtendedAttributeData data;

    public ExtendedAttributeInfoResponse(List<PIError> errors, ExtendedAttributeData data) {
        super(errors);
        this.data = data;
    }

    @Value
    public static class ExtendedAttributeData {
        Map<String, Data.Relationship> relationships;
        String type;
        String id;


        Attributes attributes;
        Map<String, String> links;

        @lombok.Value
        public static class Relationship {
            Data.Link links;

            @JsonCreator
            public Relationship(Data.Link links) {
                this.links = links;
            }
        }

        @lombok.Value
        public static class Link {
            String related;
            String self;
        }

        @lombok.Value
        public static class Attributes {
            @JsonProperty("site_version")
            String siteVersion;
            @JsonProperty("page_id")
            Long pageId;
            @JsonProperty("show_video")
            boolean showVideo;
            @JsonProperty("dsp_blocks")
            List<String> dspBlocks;
            @JsonProperty("design_templates")
            List<DesignTemplates> designTemplates;

        }

        @lombok.Value
        public static class DesignTemplates {
            @JsonProperty("page_id")
            Long pageId;
            @JsonProperty("block_id")
            Long blockId;
            @JsonProperty("design_settings")
            DesignSettings designSettings;
            @JsonProperty("type")
            String type;
        }

        @lombok.Value
        public static class DesignSettings {
            @JsonProperty("name")
            String name;
        }
    }
}
