package ru.yandex.webmaster3.core.turbo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class TurboAutoRelatedSettings {
    private static final TurboAutoRelatedSettings DEFAULT_SETTINGS = new TurboAutoRelatedSettings(TurboAutoRelatedType.OFF);

    @JsonProperty("type")
    private final TurboAutoRelatedType type;

    @JsonIgnore
    public boolean isEnabled() {
        return type != TurboAutoRelatedType.OFF;
    }

    public static TurboAutoRelatedSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    public enum TurboAutoRelatedType {
        OFF("off"), FULL_TEXT("full_text"), CARDS("cards");

        private final String displayName;

        TurboAutoRelatedType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return displayName;
        }
    }
}
