package ru.yandex.webmaster3.core.turbo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.With;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 28/08/2017.
 */
@With
public class TurboHostHeader {

    private final String title;
    private final TurboHostHeaderType type;
    private final TurboLogo logoInfo;
    private final TurboHeaderParams headerParams;

    public TurboHostHeader() {
        this(null, TurboHostHeaderType.NOLOGO, null, null);
    }

    public TurboHostHeader(String title,
                           TurboHostHeaderType type,
                           TurboLogo logoInfo) {
        this(title, type, logoInfo, null);
    }

    @JsonCreator
    public TurboHostHeader(@JsonProperty("title") String title,
                           @JsonProperty("type") TurboHostHeaderType type,
                           @JsonProperty("logoInfo") TurboLogo logoInfo,
                           @JsonProperty("headerParams") TurboHeaderParams headerParams) {
        this.title = title;
        this.type = type;
        if (type == TurboHostHeaderType.NOLOGO) {
            this.logoInfo = null;
        } else {
            this.logoInfo = logoInfo == null ? TurboLogo.builder().build() : logoInfo;
        }
        this.headerParams = headerParams;
    }

    @Description("Заголовок (имя домена) для шапки")
    public String getTitle() {
        return title;
    }

    @Description("Выбранный Тип заголовка")
    public TurboHostHeaderType getType() {
        return type;
    }

    @Description("Информация о логотипе")
    public TurboLogo getLogoInfo() {
        return logoInfo;
    }

    @Description("Настройки шапки")
    public TurboHeaderParams getHeaderParams() {
        return headerParams;
    }
}
