package ru.yandex.webmaster3.core.turbo.model;

import ru.yandex.webmaster3.core.util.enums.IntEnum;

/**
 * Created by Oleg Bazdyrev on 28/08/2017.
 */
public enum TurboHostHeaderType implements IntEnum {

    NOLOGO(0, null),
    SQUARE(1, "logo_square_x10"), // 32x32
    HORIZONTAL(2, "logo_horizontal_s_x10"), // 200x20, если оригинал квадрат то 20х20
    ECOMMERCE(3, "max_g360_c2_r4x3_pd20") //128x72, если оригинал квадрат то 72х72
    ;

    private final int value;
    private final String logoSize;

    TurboHostHeaderType(int value, String logoSize) {
        this.value = value;
        this.logoSize = logoSize;
    }

    @Override
    public int value() {
        return value;
    }

    public String getLogoSize() {
        return logoSize;
    }
}
