package ru.yandex.webmaster3.core.turbo.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.With;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 18/09/2017.
 */
@Value
@With
@Builder(toBuilder = true)
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class TurboLogo {

    @Description("Идентификатор логотипа в аватарнице")
    @JsonProperty("logoId")
    String logoId;
    @Description("Ссылки на логотип в различных вариантах (deprecated)")
    @JsonProperty("logoUrls")
    private final Map<TurboHostHeaderType, String> logoUrls;
    @Description("SVG ли это")
    @JsonProperty("svg")
    private final boolean svg;
    @Description("Логотип ли это по умолчанию (когда никакого не выбрано)")
    @JsonProperty("isDefault")
    private final boolean isDefault;
    @JsonProperty("width")
    Integer width;
    @JsonProperty("height")
    Integer height;

}
