package ru.yandex.webmaster3.core.turbo.model;


import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;

import java.util.List;

/**
 * Created by ifilippov5 on 18.06.18.
 */
public class TurboSampleData {
    public static final TypeReference<List<TurboSampleData>> TYPE_REFERENCE =
            new TypeReference<List<TurboSampleData>>() {
            };

    private final String originUrl;
    private final String title;
    private final String turboUrl;

    @JsonCreator
    public TurboSampleData(String originUrl, String title, String turboUrl) {
        this.originUrl = originUrl;
        this.title = title;
        this.turboUrl = turboUrl;
    }

    @JsonProperty("Url")
    public String getOriginUrl() {
        return originUrl;
    }

    @JsonProperty("Title")
    public String getTitle() {
        return title;
    }

    @JsonProperty("TurboUrl")
    public String getTurboUrl() {
        return turboUrl;
    }
}
