package ru.yandex.webmaster3.core.turbo.model;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * ishalaru
 * 29.02.2020
 **/
// TODO разрулить дублирование с TurboFeedType
public enum TurboSource implements IntEnum {
    AUTOPARSER(1, false, false),
    AUTOPARSER_BUTTON(1 << 1, false, false),
    RSS(1 << 2, false, true),
    YML(1 << 3, true, true),
    API(1 << 4, false, true),
    YML_LISTING(1 << 5, true, false),
    AUTO_MORDA(1 << 6, false, false);

    private final boolean manual;
    private final int value;
    private final boolean yml;

    TurboSource(int value, boolean yml, boolean manual) {
        this.manual = manual;
        this.value = value;
        this.yml = yml;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isYml() {
        return yml;
    }

    public boolean isNotYml() {
        return !yml;
    }

    public boolean isManual() {
        return manual;
    }

    public static final IntEnumResolver<TurboSource> R = IntEnumResolver.r(TurboSource.class);

}
