package ru.yandex.webmaster3.core.turbo.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 15/11/2018.
 */
public class TurboUserAgreement {

    private final String agreementCompany;
    private final String agreementLink;

    public TurboUserAgreement(@JsonProperty("agreementCompany") String agreementCompany,
                              @JsonProperty("agreementLink") String agreementLink) {
        this.agreementCompany = agreementCompany;
        this.agreementLink = agreementLink;
    }

    @Description("Название компании для пользовательского соглашения")
    public String getAgreementCompany() {
        return agreementCompany;
    }

    @Description("Ссылка на пользовательское соглашение")
    public String getAgreementLink() {
        return agreementLink;
    }

    public TurboUserAgreement withAgreementLink(String agreementLink) {
        return new TurboUserAgreement(agreementCompany, agreementLink);
    }
}
